/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id:  $:

Description:
  PNM_AP_Results.h
**************************************************************************************/

#ifndef PNM_AP_RESULTS_H_
#define PNM_AP_RESULTS_H_

#include<stdint.h>

/////////////////////////////////////////////////////////////////////////////////////
// PROFINET IO CONTROLLER V3 AP TASK ERROR CODES
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: PNM_AP_CFG_INVALID_PARAMETER
//
// MessageText:
//
// Invalid parameter.
//
#define PNM_AP_CFG_INVALID_PARAMETER     ((uint32_t)0xC0CB0001L)

//
// MessageId: PNM_AP_CFG_INVALID_STRUCT_VERSION
//
// MessageText:
//
// Invalid structure version.
//
#define PNM_AP_CFG_INVALID_STRUCT_VERSION ((uint32_t)0xC0CB0002L)

//
// MessageId: PNM_AP_CFG_INVALID_IDENTIFIER
//
// MessageText:
//
// Invalid identifier.
//
#define PNM_AP_CFG_INVALID_IDENTIFIER    ((uint32_t)0xC0CB0003L)

//
// MessageId: PNM_AP_CFG_INVALID_DEVICE_HANDLE
//
// MessageText:
//
// Invalid device handle.
//
#define PNM_AP_CFG_INVALID_DEVICE_HANDLE ((uint32_t)0xC0CB0004L)

//
// MessageId: PNM_AP_CFG_INVALID_SEND_CLOCK_FACTOR
//
// MessageText:
//
// Invalid profinet send clock factor.
//
#define PNM_AP_CFG_INVALID_SEND_CLOCK_FACTOR ((uint32_t)0xC0CB0005L)

//
// MessageId: PNM_AP_CFG_INVALID_REDUCTION_RATIO
//
// MessageText:
//
// Invalid profinet reduction ratio.
//
#define PNM_AP_CFG_INVALID_REDUCTION_RATIO ((uint32_t)0xC0CB0006L)

//
// MessageId: PNM_AP_CFG_INVALID_DATA_HOLD_FACTOR
//
// MessageText:
//
// Invalid profinet data hold factor.
//
#define PNM_AP_CFG_INVALID_DATA_HOLD_FACTOR ((uint32_t)0xC0CB0007L)

//
// MessageId: PNM_AP_CFG_INVALID_PHASE
//
// MessageText:
//
// Invalid profinet phase.
//
#define PNM_AP_CFG_INVALID_PHASE         ((uint32_t)0xC0CB0008L)

//
// MessageId: PNM_AP_CFG_INVALID_FRAME_SEND_OFFSET
//
// MessageText:
//
// Invalid profinet frame send offset.
//
#define PNM_AP_CFG_INVALID_FRAME_SEND_OFFSET ((uint32_t)0xC0CB0009L)

//
// MessageId: PNM_AP_CFG_INVALID_DOMAIN_NAME
//
// MessageText:
//
// Invalid domain name.
//
#define PNM_AP_CFG_INVALID_DOMAIN_NAME   ((uint32_t)0xC0CB000AL)

//
// MessageId: PNM_AP_CFG_INVALID_UUID
//
// MessageText:
//
// Invalid UUID.
//
#define PNM_AP_CFG_INVALID_UUID          ((uint32_t)0xC0CB000BL)

//
// MessageId: PNM_AP_CFG_INVALID_NUMBER_OF_ENTRIES
//
// MessageText:
//
// Invalid number of entries.
//
#define PNM_AP_CFG_INVALID_NUMBER_OF_ENTRIES ((uint32_t)0xC0CB000CL)

//
// MessageId: PNM_AP_CFG_INVALID_PORT_NUM
//
// MessageText:
//
// Invalid port number.
//
#define PNM_AP_CFG_INVALID_PORT_NUM      ((uint32_t)0xC0CB000DL)

//
// MessageId: PNM_AP_CFG_INVALID_STATION_NAME
//
// MessageText:
//
// Invalid station name.
//
#define PNM_AP_CFG_INVALID_STATION_NAME  ((uint32_t)0xC0CB000EL)

//
// MessageId: PNM_AP_CFG_INVALID_PORT_NAME
//
// MessageText:
//
// Invalid ethernet port name.
//
#define PNM_AP_CFG_INVALID_PORT_NAME     ((uint32_t)0xC0CB000FL)

//
// MessageId: PNM_AP_CFG_INVALID_IP_ADDRESS
//
// MessageText:
//
// Invalid IP address.
//
#define PNM_AP_CFG_INVALID_IP_ADDRESS    ((uint32_t)0xC0CB0010L)

//
// MessageId: PNM_AP_CFG_INVALID_IOCR_HANDLE
//
// MessageText:
//
// Invalid Profinet IOCR Handle.
//
#define PNM_AP_CFG_INVALID_IOCR_HANDLE   ((uint32_t)0xC0CB0011L)

//
// MessageId: PNM_AP_CFG_INVALID_IOCR_TYPE
//
// MessageText:
//
// Invalid Profinet IOCR type.
//
#define PNM_AP_CFG_INVALID_IOCR_TYPE     ((uint32_t)0xC0CB0012L)

//
// MessageId: PNM_AP_CFG_INVALID_IOCR_PROP
//
// MessageText:
//
// Invalid Profinet IOCR properties.
//
#define PNM_AP_CFG_INVALID_IOCR_PROP     ((uint32_t)0xC0CB0013L)

//
// MessageId: PNM_AP_CFG_INVALID_IOCR_DATA_LENGTH
//
// MessageText:
//
// Invalid Profinet IOCR data length.
//
#define PNM_AP_CFG_INVALID_IOCR_DATA_LENGTH ((uint32_t)0xC0CB0014L)

//
// MessageId: PNM_AP_CFG_INVALID_DPM_OFFSET
//
// MessageText:
//
// Invalid DPM Offset.
//
#define PNM_AP_CFG_INVALID_DPM_OFFSET    ((uint32_t)0xC0CB0015L)

//
// MessageId: PNM_AP_CFG_OVERLAPPING_DPM_OFFSET
//
// MessageText:
//
// Overlapping DPM IOCR data area.
//
#define PNM_AP_CFG_OVERLAPPING_DPM_OFFSET ((uint32_t)0xC0CB0016L)

//
// MessageId: PNM_AP_CFG_INVALID_SUBMODULE_HANDLE
//
// MessageText:
//
// Invalid submodule handle.
//
#define PNM_AP_CFG_INVALID_SUBMODULE_HANDLE ((uint32_t)0xC0CB0017L)

//
// MessageId: PNM_AP_CFG_INVALID_SUBMODULE_TYPE
//
// MessageText:
//
// Invalid submodule type.
//
#define PNM_AP_CFG_INVALID_SUBMODULE_TYPE ((uint32_t)0xC0CB0018L)

//
// MessageId: PNM_AP_CFG_INVALID_INPUT_DATA_LENGTH
//
// MessageText:
//
// Invalid submodule input data length.
//
#define PNM_AP_CFG_INVALID_INPUT_DATA_LENGTH ((uint32_t)0xC0CB001AL)

//
// MessageId: PNM_AP_CFG_INVALID_INPUT_FRAME_OFFSET
//
// MessageText:
//
// Invalid submodule input data offset.
//
#define PNM_AP_CFG_INVALID_INPUT_FRAME_OFFSET ((uint32_t)0xC0CB001BL)

//
// MessageId: PNM_AP_CFG_OVERLAPPING_INPUT_FRAME_OFFSET
//
// MessageText:
//
// Overlapping submodule input data areas.
//
#define PNM_AP_CFG_OVERLAPPING_INPUT_FRAME_OFFSET ((uint32_t)0xC0CB001CL)

//
// MessageId: PNM_AP_CFG_INVALID_INPUT_IOCS_OFFSET
//
// MessageText:
//
// Invalid submodule input IOCS offset.
//
#define PNM_AP_CFG_INVALID_INPUT_IOCS_OFFSET ((uint32_t)0xC0CB001DL)

//
// MessageId: PNM_AP_CFG_OVERLAPPING_INPUT_IOCS_OFFSET
//
// MessageText:
//
// Overlapping submodule input IOCS.
//
#define PNM_AP_CFG_OVERLAPPING_INPUT_IOCS_OFFSET ((uint32_t)0xC0CB001EL)

//
// MessageId: PNM_AP_CFG_INVALID_OUTPUT_DATA_LENGTH
//
// MessageText:
//
// Invalid submodule output data length.
//
#define PNM_AP_CFG_INVALID_OUTPUT_DATA_LENGTH ((uint32_t)0xC0CB001FL)

//
// MessageId: PNM_AP_CFG_INVALID_OUTPUT_FRAME_OFFSET
//
// MessageText:
//
// Invalid submodule output data offset.
//
#define PNM_AP_CFG_INVALID_OUTPUT_FRAME_OFFSET ((uint32_t)0xC0CB0020L)

//
// MessageId: PNM_AP_CFG_OVERLAPPING_OUTPUT_FRAME_OFFSET
//
// MessageText:
//
// Overlapping submodule output data areas.
//
#define PNM_AP_CFG_OVERLAPPING_OUTPUT_FRAME_OFFSET ((uint32_t)0xC0CB0021L)

//
// MessageId: PNM_AP_CFG_INVALID_OUTPUT_IOCS_OFFSET
//
// MessageText:
//
// Invalid submodule output IOCS offset.
//
#define PNM_AP_CFG_INVALID_OUTPUT_IOCS_OFFSET ((uint32_t)0xC0CB0022L)

//
// MessageId: PNM_AP_CFG_OVERLAPPING_OUTPUT_IOCS_OFFSET
//
// MessageText:
//
// Overlapping submodule output IOCS.
//
#define PNM_AP_CFG_OVERLAPPING_OUTPUT_IOCS_OFFSET ((uint32_t)0xC0CB0023L)

//
// MessageId: PNM_AP_CFG_INVALID_PLL_WINDOW
//
// MessageText:
//
// Invalid Profinet IRT PLL window.
//
#define PNM_AP_CFG_INVALID_PLL_WINDOW    ((uint32_t)0xC0CB0024L)

//
// MessageId: PNM_AP_CFG_INVALID_PTCTP_TIMEOUT
//
// MessageText:
//
// Invalid Profinet IRT Synchronization timeout (PTCP Timeout).
//
#define PNM_AP_CFG_INVALID_PTCTP_TIMEOUT ((uint32_t)0xC0CB0025L)

//
// MessageId: PNM_AP_CFG_INVALID_TAKEOVER_TIMEOUT
//
// MessageText:
//
// Invalid Profinet IRT Takeover timeout.
//
#define PNM_AP_CFG_INVALID_TAKEOVER_TIMEOUT ((uint32_t)0xC0CB0026L)

//
// MessageId: PNM_AP_CFG_INVALID_PTCP_STARTUP_TIME
//
// MessageText:
//
// Invalid Profinet IRT PTCP startup time.
//
#define PNM_AP_CFG_INVALID_PTCP_STARTUP_TIME ((uint32_t)0xC0CB0027L)

//
// MessageId: PNM_AP_CFG_INVALID_PTCP_MASTER_PRIO
//
// MessageText:
//
// Invalid Profinet IRT synchronization master priority.
//
#define PNM_AP_CFG_INVALID_PTCP_MASTER_PRIO ((uint32_t)0xC0CB0028L)

//
// MessageId: PNM_AP_CFG_INVALID_NUM_IRT_PHASES
//
// MessageText:
//
// Invalid Profinet IRT phase count.
//
#define PNM_AP_CFG_INVALID_NUM_IRT_PHASES ((uint32_t)0xC0CB0029L)

//
// MessageId: PNM_AP_CFG_INVALID_NUM_IRT_FRAMES
//
// MessageText:
//
// Invalid Profinet IRT frame count.
//
#define PNM_AP_CFG_INVALID_NUM_IRT_FRAMES ((uint32_t)0xC0CB002AL)

//
// MessageId: PNM_AP_CFG_INVALID_GREEN_PERIOD_BEGIN
//
// MessageText:
//
// Invalid Profinet IRT green period begin.
//
#define PNM_AP_CFG_INVALID_GREEN_PERIOD_BEGIN ((uint32_t)0xC0CB002CL)

//
// MessageId: PNM_AP_CFG_INVALID_ORANGE_PERIOD_BEGIN
//
// MessageText:
//
// Invalid Profinet IRT orange period begin.
//
#define PNM_AP_CFG_INVALID_ORANGE_PERIOD_BEGIN ((uint32_t)0xC0CB002EL)

//
// MessageId: PNM_AP_CFG_INVALID_FRAME_LENGTH
//
// MessageText:
//
// Invalid Profinet IRT frame length.
//
#define PNM_AP_CFG_INVALID_FRAME_LENGTH  ((uint32_t)0xC0CB002FL)

//
// MessageId: PNM_AP_CFG_INVALID_LINE_DELAY
//
// MessageText:
//
// Invalid Profinet IRT line delay.
//
#define PNM_AP_CFG_INVALID_LINE_DELAY    ((uint32_t)0xC0CB0030L)

//
// MessageId: PNM_AP_CFG_INVALID_PREAMBLE_LENGTH
//
// MessageText:
//
// Invalid Profinet frame preamble length.
//
#define PNM_AP_CFG_INVALID_PREAMBLE_LENGTH ((uint32_t)0xC0CB0031L)

//
// MessageId: PNM_AP_CFG_INVALID_PARAMETER_FLAG
//
// MessageText:
//
// Invalid parameter enable flag value.
//
#define PNM_AP_CFG_INVALID_PARAMETER_FLAG ((uint32_t)0xC0CB0032L)

//
// MessageId: PNM_AP_CFG_INVALID_PARAMETER_TYPE
//
// MessageText:
//
// Invalid parameter type.
//
#define PNM_AP_CFG_INVALID_PARAMETER_TYPE ((uint32_t)0xC0CB0033L)

//
// MessageId: PNM_AP_CFG_INVALID_FSU_MODE
//
// MessageText:
//
// Invalid Fast Startup Mode.
//
#define PNM_AP_CFG_INVALID_FSU_MODE      ((uint32_t)0xC0CB0034L)

//
// MessageId: PNM_AP_CFG_INVALID_FS_HELLO_INTERVAL
//
// MessageText:
//
// Invalid Fast Startup Hello telegram interval.
//
#define PNM_AP_CFG_INVALID_FS_HELLO_INTERVAL ((uint32_t)0xC0CB0035L)

//
// MessageId: PNM_AP_CFG_INVALID_FS_HELLO_RETRY
//
// MessageText:
//
// Invalid Fast Startup Hello telegram retry.
//
#define PNM_AP_CFG_INVALID_FS_HELLO_RETRY ((uint32_t)0xC0CB0036L)

//
// MessageId: PNM_AP_CFG_INVALID_FS_HELLO_DELAY
//
// MessageText:
//
// Invalid Fast Startup Hello delay.
//
#define PNM_AP_CFG_INVALID_FS_HELLO_DELAY ((uint32_t)0xC0CB0037L)

//
// MessageId: PNM_AP_CFG_INVALID_SYNC_MODE
//
// MessageText:
//
// Invalid sychronization mode.
//
#define PNM_AP_CFG_INVALID_SYNC_MODE     ((uint32_t)0xC0CB0038L)

//
// MessageId: PNM_AP_CFG_INVALID_MAUTYPE_MODE
//
// MessageText:
//
// Invalid mau type mode.
//
#define PNM_AP_CFG_INVALID_MAUTYPE_MODE  ((uint32_t)0xC0CB0039L)

//
// MessageId: PNM_AP_CFG_INVALID_DOMAIN_BOUNDARY
//
// MessageText:
//
// Invalid domain boundary value.
//
#define PNM_AP_CFG_INVALID_DOMAIN_BOUNDARY ((uint32_t)0xC0CB003AL)

//
// MessageId: PNM_AP_CFG_INVALID_DCP_BOUNDARY
//
// MessageText:
//
// Invalid DCP boundary value.
//
#define PNM_AP_CFG_INVALID_DCP_BOUNDARY  ((uint32_t)0xC0CB003BL)

//
// MessageId: PNM_AP_CFG_INVALID_PEERTOPEER_BOUNDARY
//
// MessageText:
//
// Invalid peer to peer boundary value.
//
#define PNM_AP_CFG_INVALID_PEERTOPEER_BOUNDARY ((uint32_t)0xC0CB003CL)

//
// MessageId: PNM_AP_CFG_INVALID_MULTIPLE_INTERFACE_MODE
//
// MessageText:
//
// Invalid multiple interface mode value.
//
#define PNM_AP_CFG_INVALID_MULTIPLE_INTERFACE_MODE ((uint32_t)0xC0CB003DL)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_INSTANCE
//
// MessageText:
//
// Invalid mrp instance.
//
#define PNM_AP_CFG_INVALID_MRP_INSTANCE  ((uint32_t)0xC0CB003EL)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_CHECK
//
// MessageText:
//
// Invalid mrp check value.
//
#define PNM_AP_CFG_INVALID_MRP_CHECK     ((uint32_t)0xC0CB003FL)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_ROLE
//
// MessageText:
//
// Invalid mrp role.
//
#define PNM_AP_CFG_INVALID_MRP_ROLE      ((uint32_t)0xC0CB0040L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_PARAMETERS
//
// MessageText:
//
// Invalid mrp parameter.
//
#define PNM_AP_CFG_INVALID_MRP_PARAMETERS ((uint32_t)0xC0CB0041L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_MANAGER_PRIO
//
// MessageText:
//
// Invalid mrp manager priority.
//
#define PNM_AP_CFG_INVALID_MRP_MANAGER_PRIO ((uint32_t)0xC0CB0042L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_TOPO_CHANGE_INTERVAL
//
// MessageText:
//
// Invalid mrp topology change frame interval value.
//
#define PNM_AP_CFG_INVALID_MRP_TOPO_CHANGE_INTERVAL ((uint32_t)0xC0CB0043L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_TOPO_REPEAT_COUNT
//
// MessageText:
//
// Invalid mrp topology change frame repeat value.
//
#define PNM_AP_CFG_INVALID_MRP_TOPO_REPEAT_COUNT ((uint32_t)0xC0CB0044L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_SHORT_TEST_INTERVAL
//
// MessageText:
//
// Invalid mrp short test frame interval value.
//
#define PNM_AP_CFG_INVALID_MRP_SHORT_TEST_INTERVAL ((uint32_t)0xC0CB0045L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_DEFAULT_TEST_INTERVAL
//
// MessageText:
//
// Invalid mrp default test frame interval value.
//
#define PNM_AP_CFG_INVALID_MRP_DEFAULT_TEST_INTERVAL ((uint32_t)0xC0CB0046L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_TEST_MONITOR_COUNT
//
// MessageText:
//
// Invalid mrp test monitor countvalue.
//
#define PNM_AP_CFG_INVALID_MRP_TEST_MONITOR_COUNT ((uint32_t)0xC0CB0047L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_LINK_DOWN_INTERVAL
//
// MessageText:
//
// Invalid mrp link down frame interval.
//
#define PNM_AP_CFG_INVALID_MRP_LINK_DOWN_INTERVAL ((uint32_t)0xC0CB0048L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_LINK_UP_INTERVAL
//
// MessageText:
//
// Invalid mrp link up frame interval.
//
#define PNM_AP_CFG_INVALID_MRP_LINK_UP_INTERVAL ((uint32_t)0xC0CB0049L)

//
// MessageId: PNM_AP_CFG_INVALID_MRP_LINK_CHANGE_COUNT
//
// MessageText:
//
// Invalid mrp link change repeat value.
//
#define PNM_AP_CFG_INVALID_MRP_LINK_CHANGE_COUNT ((uint32_t)0xC0CB004AL)

//
// MessageId: PNM_AP_CFG_INVALID_FIBEROPTIC_PARAMETERS
//
// MessageText:
//
// Invalid fiber optic parameter value.
//
#define PNM_AP_CFG_INVALID_FIBEROPTIC_PARAMETERS ((uint32_t)0xC0CB004BL)

//
// MessageId: PNM_AP_CFG_DUPLICAT_UUID
//
// MessageText:
//
// Doubly used UUID value.
//
#define PNM_AP_CFG_DUPLICAT_UUID         ((uint32_t)0xC0CB004CL)

//
// MessageId: PNM_AP_CFG_DUPLICAT_NAME_OF_STATION
//
// MessageText:
//
// Doubly used Profinet Name Of Station value.
//
#define PNM_AP_CFG_DUPLICAT_NAME_OF_STATION ((uint32_t)0xC0CB004DL)

//
// MessageId: PNM_AP_CFG_DUPLICAT_IP_ADDRESS
//
// MessageText:
//
// Doubly used IPv4 network address.
//
#define PNM_AP_CFG_DUPLICAT_IP_ADDRESS   ((uint32_t)0xC0CB004EL)

//
// MessageId: PNM_AP_CFG_INVALID_RTA_TIMEOUT_FACTOR
//
// MessageText:
//
// Invalid value for alarm frame timeout.
//
#define PNM_AP_CFG_INVALID_RTA_TIMEOUT_FACTOR ((uint32_t)0xC0CB004FL)

//
// MessageId: PNM_AP_CFG_INVALID_RTA_RETRIES
//
// MessageText:
//
// Invalid value for alarm frame retry.
//
#define PNM_AP_CFG_INVALID_RTA_RETRIES   ((uint32_t)0xC0CB0050L)

//
// MessageId: PNM_AP_CFG_INVALID_MAX_ALARM_DATA_LENGTH
//
// MessageText:
//
// Invalid value for alarm data length.
//
#define PNM_AP_CFG_INVALID_MAX_ALARM_DATA_LENGTH ((uint32_t)0xC0CB0051L)

//
// MessageId: PNM_AP_CFG_AR_TYPE_NOT_SUPPORTED
//
// MessageText:
//
// Unsupported application relation type.
//
#define PNM_AP_CFG_AR_TYPE_NOT_SUPPORTED ((uint32_t)0xC0CB0052L)

//
// MessageId: PNM_AP_CFG_INVALID_AR_TYPE
//
// MessageText:
//
// Invalid application relation type.
//
#define PNM_AP_CFG_INVALID_AR_TYPE       ((uint32_t)0xC0CB0053L)

//
// MessageId: PNM_AP_CFG_INVALID_SLOT
//
// MessageText:
//
// Invalid module slot number.
//
#define PNM_AP_CFG_INVALID_SLOT          ((uint32_t)0xC0CB0054L)

//
// MessageId: PNM_AP_CFG_INVALID_MODULE_IDENT
//
// MessageText:
//
// Invalid module id number.
//
#define PNM_AP_CFG_INVALID_MODULE_IDENT  ((uint32_t)0xC0CB0055L)

//
// MessageId: PNM_AP_CFG_INVALID_SUBSLOT
//
// MessageText:
//
// Invalid submodule subslot number.
//
#define PNM_AP_CFG_INVALID_SUBSLOT       ((uint32_t)0xC0CB0056L)

//
// MessageId: PNM_AP_CFG_NO_PORT_SUBMODULE
//
// MessageText:
//
// The specified submodule is not a port submodule.
//
#define PNM_AP_CFG_NO_PORT_SUBMODULE     ((uint32_t)0xC0CB0057L)

//
// MessageId: PNM_AP_CFG_INVALID_MAX_BRIDGE_DELAY
//
// MessageText:
//
// Invalid maximum ethernet bridge delay.
//
#define PNM_AP_CFG_INVALID_MAX_BRIDGE_DELAY ((uint32_t)0xC0CB0058L)

//
// MessageId: PNM_AP_CFG_INVALID_MAX_PORT_TX_DELAY
//
// MessageText:
//
// Invalid maximum port tx delay.
//
#define PNM_AP_CFG_INVALID_MAX_PORT_TX_DELAY ((uint32_t)0xC0CB0059L)

//
// MessageId: PNM_AP_CFG_INVALID_MAX_PORT_RX_DELAY
//
// MessageText:
//
// Invalid maximum port rx delay.
//
#define PNM_AP_CFG_INVALID_MAX_PORT_RX_DELAY ((uint32_t)0xC0CB005AL)

//
// MessageId: PNM_AP_CFG_INVALID_MAX_LINE_DELAY
//
// MessageText:
//
// Invalid maximum line delay.
//
#define PNM_AP_CFG_INVALID_MAX_LINE_DELAY ((uint32_t)0xC0CB005BL)

//
// MessageId: PNM_AP_CFG_INVALID_YELLOW_TIME
//
// MessageText:
//
// Invalid length of yellow interval.
//
#define PNM_AP_CFG_INVALID_YELLOW_TIME   ((uint32_t)0xC0CB005CL)

//
// MessageId: PNM_AP_CFG_INVALID_FRAME_DATA_PROP
//
// MessageText:
//
// Invalid frame data properties.
//
#define PNM_AP_CFG_INVALID_FRAME_DATA_PROP ((uint32_t)0xC0CB005DL)

//
// MessageId: PNM_AP_CFG_INVALID_FRAME_ID
//
// MessageText:
//
// Invalid frame id value.
//
#define PNM_AP_CFG_INVALID_FRAME_ID      ((uint32_t)0xC0CB005EL)

//
// MessageId: PNM_AP_CFG_INVALID_FRAME_DETAIL_SYNC_FRAME_MASK
//
// MessageText:
//
// Invalid framedetails sync frame mask.
//
#define PNM_AP_CFG_INVALID_FRAME_DETAIL_SYNC_FRAME_MASK ((uint32_t)0xC0CB005FL)

//
// MessageId: PNM_AP_CFG_INVALID_FRAME_DETAIL_FRAME_SEND_OFFSET
//
// MessageText:
//
// Invalid framedetails send offset.
//
#define PNM_AP_CFG_INVALID_FRAME_DETAIL_FRAME_SEND_OFFSET ((uint32_t)0xC0CB0060L)

//
// MessageId: PNM_AP_CFG_INVALID_NUM_IRT_ASSIGNMENT
//
// MessageText:
//
// Invalid number of IRT phase assignments.
//
#define PNM_AP_CFG_INVALID_NUM_IRT_ASSIGNMENT ((uint32_t)0xC0CB0061L)

//
// MessageId: PNM_AP_CFG_DUPLICAT_SYNC_MASTER
//
// MessageText:
//
// More than one synchronization master defined.
//
#define PNM_AP_CFG_DUPLICAT_SYNC_MASTER  ((uint32_t)0xC0CB0062L)

//
// MessageId: PNM_AP_CFG_INVALID_NUMBER_OF_PORTS
//
// MessageText:
//
// Invalid number of ports.
//
#define PNM_AP_CFG_INVALID_NUMBER_OF_PORTS ((uint32_t)0xC0CB0063L)

//
// MessageId: PNM_AP_CFG_TOPO_PORT_ALREADY_CONFIGURED
//
// MessageText:
//
// The referenced port's topology is already configured.
//
#define PNM_AP_CFG_TOPO_PORT_ALREADY_CONFIGURED ((uint32_t)0xC0CB0064L)

//
// MessageId: PNM_AP_CFG_TOPO_INFO_MISMATCH
//
// MessageText:
//
// Inconsistent topology configured.
//
#define PNM_AP_CFG_TOPO_INFO_MISMATCH    ((uint32_t)0xC0CB0065L)

//
// MessageId: PNM_AP_CFG_INVALID_CONFIG_STATE
//
// MessageText:
//
// Wrong configuration state.
//
#define PNM_AP_CFG_INVALID_CONFIG_STATE  ((uint32_t)0xC0CB0066L)

//
// MessageId: PNM_AP_CFG_MISSING_IOCR
//
// MessageText:
//
// IOCR missing in configuration.
//
#define PNM_AP_CFG_MISSING_IOCR          ((uint32_t)0xC0CB0067L)

//
// MessageId: PNM_AP_CFG_MAX_NUMBER_IOCR_EXCEEDED
//
// MessageText:
//
// Maximum possible number of IOCRs exceeded.
//
#define PNM_AP_CFG_MAX_NUMBER_IOCR_EXCEEDED ((uint32_t)0xC0CB0068L)

//
// MessageId: PNM_AP_CFG_INVALID_DAP_CONFGURATION
//
// MessageText:
//
// Invalid configuration of a device access point (DAP).
//
#define PNM_AP_CFG_INVALID_DAP_CONFGURATION ((uint32_t)0xC0CB0069L)

//
// MessageId: PNM_AP_CFG_INVALID_DROP_BUDGET
//
// MessageText:
//
// Invalid value for network switch drop budget.
//
#define PNM_AP_CFG_INVALID_DROP_BUDGET   ((uint32_t)0xC0CB006AL)

//
// MessageId: PNM_AP_CFG_INVALID_REDORANGE_PERIOD_BEGIN
//
// MessageText:
//
// Invalid value for Profinet IRT red period begin.
//
#define PNM_AP_CFG_INVALID_REDORANGE_PERIOD_BEGIN ((uint32_t)0xC0CB006BL)

//
// MessageId: PNM_AP_CFG_PERFORMANCELIMIT_EXCEEDED
//
// MessageText:
//
// The configured item exceeds the firmware's performance limitation.
//
#define PNM_AP_CFG_PERFORMANCELIMIT_EXCEEDED ((uint32_t)0xC0CB006CL)

//
// MessageId: PNM_AP_CFG_FEATURE_NOT_SUPPORTED
//
// MessageText:
//
// The configured feature is not supported
//
#define PNM_AP_CFG_FEATURE_NOT_SUPPORTED ((uint32_t)0xC0CB006DL)

//
// MessageId: PNM_AP_CFG_IRT_LEGACY_ADVANCED_MIXED
//
// MessageText:
//
// The configuration contains legacy and advanced startup up IRT ARs
//
#define PNM_AP_CFG_IRT_LEGACY_ADVANCED_MIXED ((uint32_t)0xC0CB006EL)

//
// MessageId: PNM_AP_CFG_INVALID_ARPROPERTIES
//
// MessageText:
//
// An invalid value for 'AR properties' was configured
//
#define PNM_AP_CFG_INVALID_ARPROPERTIES  ((uint32_t)0xC0CB006FL)

//
// MessageId: PNM_AP_CFG_INVALID_NAMEOFSTATION
//
// MessageText:
//
// An invalid value for name of station was configured
//
#define PNM_AP_CFG_INVALID_NAMEOFSTATION ((uint32_t)0xC0CB0070L)

//
// MessageId: PNM_AP_ERR_DEVICE_NOT_FOUND
//
// MessageText:
//
// A device with the given name of station was not found in the network
//
#define PNM_AP_ERR_DEVICE_NOT_FOUND      ((uint32_t)0xC0CB0071L)

//
// MessageId: PNM_AP_ERR_MULTIPLE_DEVICES_FOUND
//
// MessageText:
//
// Multiple devices using the given name of station have been found in the network
//
#define PNM_AP_ERR_MULTIPLE_DEVICES_FOUND ((uint32_t)0xC0CB0072L)

//
// MessageId: PNM_AP_ERR_DCP_FAILED
//
// MessageText:
//
// Configuring the device using DCP failed
//
#define PNM_AP_ERR_DCP_FAILED            ((uint32_t)0xC0CB0073L)

//
// MessageId: PNM_AP_ERR_IP_CONFLICT
//
// MessageText:
//
// The IP address is already used by another device in the network
//
#define PNM_AP_ERR_IP_CONFLICT           ((uint32_t)0xC0CB0074L)

//
// MessageId: PNM_AP_CFG_INVALID_CONTROLLERAPPLICATIONCYCLEFACTOR
//
// MessageText:
//
// An invalid value for the Controller Application Cycle Factor has been configured
//
#define PNM_AP_CFG_INVALID_CONTROLLERAPPLICATIONCYCLEFACTOR ((uint32_t)0xC0CB0075L)

//
// MessageId: PNM_AP_CFG_INVALID_TIMEDATACYCLE
//
// MessageText:
//
// An invalid value for the Time Data Cycle has been configured
//
#define PNM_AP_CFG_INVALID_TIMEDATACYCLE ((uint32_t)0xC0CB0076L)

//
// MessageId: PNM_AP_CFG_INVALID_TIMEIOINPUT
//
// MessageText:
//
// An invalid value for Time IO Input has been configured
//
#define PNM_AP_CFG_INVALID_TIMEIOINPUT   ((uint32_t)0xC0CB0077L)

//
// MessageId: PNM_AP_CFG_INVALID_TIMEIOINPUTVALID
//
// MessageText:
//
// An invalid value for Time IO Input Valid has been configured
//
#define PNM_AP_CFG_INVALID_TIMEIOINPUTVALID ((uint32_t)0xC0CB0078L)

//
// MessageId: PNM_AP_CFG_INVALID_TIMEIOOUTPUT
//
// MessageText:
//
// An invalid value for Time IO Output has been configured
//
#define PNM_AP_CFG_INVALID_TIMEIOOUTPUT  ((uint32_t)0xC0CB0079L)

//
// MessageId: PNM_AP_CFG_INVALID_TIMEIOOUTPUTVALID
//
// MessageText:
//
// An invalid value for Time IO Output Valid has been configured
//
#define PNM_AP_CFG_INVALID_TIMEIOOUTPUTVALID ((uint32_t)0xC0CB0080L)

//
// MessageId: PNM_AP_ERR_NO_MRM_LICENSE
//
// MessageText:
//
// MRP Manager configured but license not available.
//
#define PNM_AP_ERR_NO_MRM_LICENSE        ((uint32_t)0xC0CB0081L)

//
// MessageId: PNM_AP_CFG_MULTIPLE_INTERFACE_MODE_MIXED
//
// MessageText:
//
// Inconsistent MultipleInterface mode configuration. Mixed configuration (LLDP V2.2 and LLDP V2.3) is not allowed.
//
#define PNM_AP_CFG_MULTIPLE_INTERFACE_MODE_MIXED ((uint32_t)0xC0CB0082L)

//
// MessageId: PNM_AP_CFG_INVALID_DATA_HOLD_TIME
//
// MessageText:
//
// Invalid profinet data hold time.
//
#define PNM_AP_CFG_INVALID_DATA_HOLD_TIME ((uint32_t)0xC0CB0083L)

//
// MessageId: ERR_PNM_AP_INVALID_ALARM_PRIORITY
//
// MessageText:
//
// An invalid alarm priority value was specified in request.
//
#define ERR_PNM_AP_INVALID_ALARM_PRIORITY ((uint32_t)0xC0CB0084L)

//
// MessageId: ERR_PNM_AP_NO_ALARM_PENDING
//
// MessageText:
//
// No alarm pending for device handle and priority specified in request.
//
#define ERR_PNM_AP_NO_ALARM_PENDING      ((uint32_t)0xC0CB0085L)

//
// MessageId: ERR_PNM_AP_WRONG_ALARM_TYPE
//
// MessageText:
//
// The alarm acknowledge service request contains a different alarm type than alarm indication.
//
#define ERR_PNM_AP_WRONG_ALARM_TYPE      ((uint32_t)0xC0CB0086L)

//
// MessageId: ERR_PNM_AP_WRONG_ALARM_STATE
//
// MessageText:
//
// The alarm acknowledge service request was used before an alarm was indicated and responded
//
#define ERR_PNM_AP_WRONG_ALARM_STATE           ((uint32_t)0xC0CB0087L)

#endif  /* PNM_AP_RESULTS_H_ */
